#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll w, v;
    int idx;
    double ratio;
} Ponco;

int cmp(const void *a, const void *b) {
    Ponco *x = (Ponco *)a;
    Ponco *y = (Ponco *)b;
    if (x->ratio < y->ratio) return 1;
    if (x->ratio > y->ratio) return -1;
    return 0;
}

int main() {
    int N;
    ll W;
    double eps;
    scanf("%d %lld %lf", &N, &W, &eps);

    Ponco p[305];
    for (int i = 0; i < N; i++) {
        scanf("%lld %lld", &p[i].w, &p[i].v);
        p[i].idx = i + 1;
        p[i].ratio = (double)p[i].v / (double)p[i].w;
    }
    qsort(p, N, sizeof(Ponco), cmp);

    ll curW = 0, curV = 0;
    int take[305] = {0};

    for (int i = 0; i < N; i++) {
        if (curW + p[i].w <= W) {
            curW += p[i].w;
            curV += p[i].v;
            take[i] = 1;
        }
    }
    ll bestSingleV = 0;
    int bestSingle = -1;
    for (int i = 0; i < N; i++) {
        if (p[i].w <= W && p[i].v > bestSingleV) {
            bestSingleV = p[i].v;
            bestSingle = i;
        }
    }
    if (bestSingleV > curV) {
        printf("1\n%d\n", p[bestSingle].idx);
    } else {
        int cnt = 0;
        for (int i = 0; i < N; i++) if (take[i]) cnt++;

        printf("%d\n", cnt);
        for (int i = 0; i < N; i++) {
            if (take[i]) printf("%d ", p[i].idx);
        }
        printf("\n");
    }

    return 0;
}